package com.hero.objects.skills;

import java.util.ArrayList;

import org.jdom.Element;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.util.Constants;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class TransportFamiliarity extends Skill {

	private static String xmlID = "TRANSPORT_FAMILIARITY";

	private boolean combatDrivingDiscounted = false;

	private boolean combatPilotingDiscounted = false;

	private boolean ridingDiscounted = false;

	public TransportFamiliarity(Element template) {
		super(template, TransportFamiliarity.xmlID);
		alias = "TF";
	}

	private boolean checkForBonus(String type, ArrayList<Adder> adders) {
		for (Adder ad : adders) {
			if (ad.containsType(type) && (ad.getTotalCost() == 1)) {
				return true;
			} else if ((ad.getAssignedAdders() != null)
					&& (ad.getAssignedAdders().size() > 0) && !ad.isSelected()) {
				boolean check = checkForBonus(type, ad.getAssignedAdders());
				if (check) {
					return true;
				}
			}
		}
		return false;
	}

	@Override
	public String getColumn2Output() {
		String ret = getAlias();
		if ((getInput() != null) && (getInput().trim().length() > 0)) {
			ret += ":  " + getInput();
		}
		if (!HeroDesigner.getInstance().getPrefs().useWG()
				&& (getCharacteristicChoices() != null)
				&& (getCharacteristicChoices().size() > 1)
				&& !(getCharacteristic() == Constants.GENERAL)) {
			ret += " ("
					+ Constants.getCharacteristicString(getCharacteristic())
					+ "-based)";
		}
		String adderString = getAdderString();
		if (adderString.trim().length() > 0) {
			ret += ":  ";
			ret += adderString;
		}
		String modifierString = getModifierString();
		if (modifierString.trim().length() > 0) {
			ret += " ";
			ret += getModifierString();
		}
		//ret += getModifierString();
		if ((getEndUsage() > 0)
				&& (GenericObject.findObjectByID(HeroDesigner.getActiveHero()
						.getPowers(), "ENDURANCERESERVE") != null)
				&& (GenericObject.findObjectByID(getAllAssignedModifiers(),
						"ENDRESERVEOREND") == null)
				&& !HeroDesigner.getInstance().getPrefs().useWG()) {
			if (getUseENDReserve()) {
				ret += " (uses END Reserve)";
			} else {
				ret += " (uses Personal END)";
			}
		}
		return ret;
	}

	@Override
	public String getColumn3Output() {
		return "";
	}

	@Override
	public String getRoll() {
		return "";
	}

	@Override
	public double getTotalCost() {
		double total = super.getTotalCost();
		boolean applyDriving = false;
		boolean applyPiloting = false;
		boolean applyRiding = false;

		// first, see which types to check for discounts on...
		ArrayList<Adder> adders = getAssignedAdders();
		applyDriving = checkForBonus("DRIVING", adders);
		applyPiloting = checkForBonus("PILOTING", adders);
		applyRiding = checkForBonus("RIDING", adders);

		// now, see if the discounts are actually available...
		if (applyDriving) {
			applyDriving = false;
			ArrayList<GenericObject> skills = HeroDesigner.getActiveHero()
					.getSkills();
			for (GenericObject o : skills) {
				if (o.getXMLID().equalsIgnoreCase("COMBAT_DRIVING")) {
					applyDriving = true;
				}
			}
		}
		if (applyPiloting) {
			applyPiloting = false;
			ArrayList<GenericObject> skills = HeroDesigner.getActiveHero()
					.getSkills();
			for (GenericObject o : skills) {
				if (o.getXMLID().equalsIgnoreCase("COMBAT_PILOTING")) {
					applyPiloting = true;
				}
			}
		}
		if (applyRiding) {
			applyRiding = false;
			ArrayList<GenericObject> skills = HeroDesigner.getActiveHero()
					.getSkills();
			for (GenericObject o : skills) {
				if (o.getXMLID().equalsIgnoreCase("RIDING")) {
					applyRiding = true;
				}
			}
		}

		// now see if someone else has nabbed the discount already....
		if (applyDriving || applyPiloting || applyRiding) {
			ArrayList<GenericObject> skills = HeroDesigner.getActiveHero()
					.getSkills();
			for (GenericObject o : skills) {
				if (o.getXMLID().equals(getXMLID()) && !(o.getID() == getID())) {
					TransportFamiliarity tf = (TransportFamiliarity) o;
					if (tf.isCombatDrivingDiscounted()) {
						applyDriving = false;
					}
					if (tf.isCombatPilotingDiscounted()) {
						applyPiloting = false;
					}
					if (tf.isRidingDiscounted()) {
						applyRiding = false;
					}
				}
			}
		}

		// now (finally) apply any discounts that remain....
		if (applyDriving) {
			combatDrivingDiscounted = true;
			total += -1;
		}
		if (applyPiloting) {
			combatPilotingDiscounted = true;
			total += -1;
		}
		if (applyRiding) {
			ridingDiscounted = true;
			total += -1;
		}

		return total;
	}

	@Override
	protected void init(Element element) {
		rollBased = false;
		super.init(element);
	}

	private boolean isCombatDrivingDiscounted() {
		return combatDrivingDiscounted;
	}

	private boolean isCombatPilotingDiscounted() {
		return combatPilotingDiscounted;
	}

	private boolean isRidingDiscounted() {
		return ridingDiscounted;
	}

}